<?php

$errors = [];

if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
} else if (isset($exception)) {
    $message = [
        'type' => 'error',
        'message' => $exception->getMessage()
    ];

    if (get_class($exception) === 'ValidationException') {
        $errors = $exception->getErrors();
    }
}

$alertType = '';

if (isset($message['type']) && $message['type'] === 'error') {
    $alertType = 'danger';
} else {
    $alertType = 'success';
}

?>

<?php if(isset($message)): ?>
    <div 
        role="alert"
        class="my-3 alert alert-<?= $alertType ?>"
    >
        <?= $message['message'] ?>
    </div>
<?php endif ?>